'use strict';

withdrawals.controllers.module('delete-modal', [], function () {
	return {
		vue: true,
		name: 'gx-delete-modal',
		template: '#delete-modal',
		parent: 'gx-withdrawals-overview',
		data: function data() {
			return {
				lang: {
					title: jse.core.lang.translate('delete_modal_title', 'withdrawals'),
					text: jse.core.lang.translate('delete_modal_text', 'withdrawals'),
					close: jse.core.lang.translate('delete_modal_close', 'withdrawals'),
					confirm: jse.core.lang.translate('delete_modal_confirm', 'withdrawals'),
					labels: {
						id: jse.core.lang.translate('delete_modal_label_id', 'withdrawals'),
						date: jse.core.lang.translate('delete_modal_label_date', 'withdrawals'),
						order: jse.core.lang.translate('delete_modal_label_order', 'withdrawals'),
						customer: jse.core.lang.translate('delete_modal_label_customer', 'withdrawals')
					}
				}
			};
		},
		props: {
			withdrawal: {
				type: Object
			}
		},
		watch: {
			withdrawal: function withdrawal(newVal) {
				if (newVal !== undefined) {
					$('.delete-modal.modal').modal('show');
				}
			}
		},
		methods: {
			confirm: function confirm() {
				var _this = this;

				jse.libs.xhr.post({
					url: './admin.php?do=Withdrawals/DeleteWithdrawal',
					data: { id: this.withdrawal.id }
				}).done(function (response) {
					_this.$emit('reload-overview');
				}).fail(function (response) {
					console.error('Could not load withdrawal details.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_delete_withdrawal', 'withdrawals'));
				});
				$('.delete-modal.modal').modal('hide');
			}
		},
		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpdGhkcmF3YWxzL2RlbGV0ZS1tb2RhbC5qcyJdLCJuYW1lcyI6WyJ3aXRoZHJhd2FscyIsImNvbnRyb2xsZXJzIiwibW9kdWxlIiwidnVlIiwibmFtZSIsInRlbXBsYXRlIiwicGFyZW50IiwiZGF0YSIsImxhbmciLCJ0aXRsZSIsImpzZSIsImNvcmUiLCJ0cmFuc2xhdGUiLCJ0ZXh0IiwiY2xvc2UiLCJjb25maXJtIiwibGFiZWxzIiwiaWQiLCJkYXRlIiwib3JkZXIiLCJjdXN0b21lciIsInByb3BzIiwid2l0aGRyYXdhbCIsInR5cGUiLCJPYmplY3QiLCJ3YXRjaCIsIm5ld1ZhbCIsInVuZGVmaW5lZCIsIiQiLCJtb2RhbCIsIm1ldGhvZHMiLCJsaWJzIiwieGhyIiwicG9zdCIsInVybCIsImRvbmUiLCIkZW1pdCIsImZhaWwiLCJyZXNwb25zZSIsImNvbnNvbGUiLCJlcnJvciIsImluZm9fbWVzc2FnZXMiLCJhZGRFcnJvciIsImluaXQiXSwibWFwcGluZ3MiOiI7O0FBQUFBLFlBQVlDLFdBQVosQ0FBd0JDLE1BQXhCLENBQStCLGNBQS9CLEVBQ0MsRUFERCxFQUVDLFlBQU07QUFDTCxRQUFPO0FBQ05DLE9BQUssSUFEQztBQUVOQyxRQUFNLGlCQUZBO0FBR05DLFlBQVUsZUFISjtBQUlOQyxVQUFRLHlCQUpGO0FBS05DLFFBQU07QUFBQSxVQUFPO0FBQ1pDLFVBQU07QUFDTEMsWUFBT0MsSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0Isb0JBQXhCLEVBQThDLGFBQTlDLENBREY7QUFFTEMsV0FBTUgsSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0IsbUJBQXhCLEVBQTZDLGFBQTdDLENBRkQ7QUFHTEUsWUFBT0osSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0Isb0JBQXhCLEVBQThDLGFBQTlDLENBSEY7QUFJTEcsY0FBU0wsSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0Isc0JBQXhCLEVBQWdELGFBQWhELENBSko7QUFLTEksYUFBUTtBQUNQQyxVQUFJUCxJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3Qix1QkFBeEIsRUFBaUQsYUFBakQsQ0FERztBQUVQTSxZQUFNUixJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3Qix5QkFBeEIsRUFBbUQsYUFBbkQsQ0FGQztBQUdQTyxhQUFPVCxJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3QiwwQkFBeEIsRUFBb0QsYUFBcEQsQ0FIQTtBQUlQUSxnQkFBVVYsSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0IsNkJBQXhCLEVBQXVELGFBQXZEO0FBSkg7QUFMSDtBQURNLElBQVA7QUFBQSxHQUxBO0FBbUJOUyxTQUFPO0FBQ05DLGVBQVk7QUFDWEMsVUFBTUM7QUFESztBQUROLEdBbkJEO0FBd0JOQyxTQUFPO0FBQ05ILGFBRE0sc0JBQ0tJLE1BREwsRUFDYTtBQUNsQixRQUFJQSxXQUFXQyxTQUFmLEVBQTBCO0FBQ3pCQyxPQUFFLHFCQUFGLEVBQXlCQyxLQUF6QixDQUErQixNQUEvQjtBQUNBO0FBQ0Q7QUFMSyxHQXhCRDtBQStCTkMsV0FBUztBQUNSZixVQURRLHFCQUNFO0FBQUE7O0FBQ1RMLFFBQUlxQixJQUFKLENBQVNDLEdBQVQsQ0FBYUMsSUFBYixDQUFrQjtBQUNqQkMsVUFBSyw2Q0FEWTtBQUVqQjNCLFdBQU0sRUFBQ1UsSUFBSSxLQUFLSyxVQUFMLENBQWdCTCxFQUFyQjtBQUZXLEtBQWxCLEVBR0drQixJQUhILENBR1Esb0JBQVk7QUFDbkIsV0FBS0MsS0FBTCxDQUFXLGlCQUFYO0FBQ0EsS0FMRCxFQUtHQyxJQUxILENBS1EsVUFBQ0MsUUFBRCxFQUFjO0FBQ3JCQyxhQUFRQyxLQUFSLENBQWMsb0NBQWQsRUFBb0RGLFFBQXBEO0FBQ0E1QixTQUFJcUIsSUFBSixDQUFTVSxhQUFULENBQXVCQyxRQUF2QixDQUFnQ2hDLElBQUlDLElBQUosQ0FBU0gsSUFBVCxDQUFjSSxTQUFkLENBQXdCLG1DQUF4QixFQUE2RCxhQUE3RCxDQUFoQztBQUNBLEtBUkQ7QUFTQWdCLE1BQUUscUJBQUYsRUFBeUJDLEtBQXpCLENBQStCLE1BQS9CO0FBQ0E7QUFaTyxHQS9CSDtBQTZDTmMsUUFBTTtBQUFBLFVBQVFSLE1BQVI7QUFBQTtBQTdDQSxFQUFQO0FBK0NBLENBbERGIiwiZmlsZSI6IndpdGhkcmF3YWxzL2RlbGV0ZS1tb2RhbC5qcyIsInNvdXJjZXNDb250ZW50IjpbIndpdGhkcmF3YWxzLmNvbnRyb2xsZXJzLm1vZHVsZSgnZGVsZXRlLW1vZGFsJyxcblx0W10sXG5cdCgpID0+IHtcblx0XHRyZXR1cm4ge1xuXHRcdFx0dnVlOiB0cnVlLFxuXHRcdFx0bmFtZTogJ2d4LWRlbGV0ZS1tb2RhbCcsXG5cdFx0XHR0ZW1wbGF0ZTogJyNkZWxldGUtbW9kYWwnLFxuXHRcdFx0cGFyZW50OiAnZ3gtd2l0aGRyYXdhbHMtb3ZlcnZpZXcnLFxuXHRcdFx0ZGF0YTogKCkgPT4gKHtcblx0XHRcdFx0bGFuZzoge1xuXHRcdFx0XHRcdHRpdGxlOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZGVsZXRlX21vZGFsX3RpdGxlJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0dGV4dDoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2RlbGV0ZV9tb2RhbF90ZXh0JywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0Y2xvc2U6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdkZWxldGVfbW9kYWxfY2xvc2UnLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRjb25maXJtOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZGVsZXRlX21vZGFsX2NvbmZpcm0nLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRsYWJlbHM6IHtcblx0XHRcdFx0XHRcdGlkOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZGVsZXRlX21vZGFsX2xhYmVsX2lkJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0XHRkYXRlOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZGVsZXRlX21vZGFsX2xhYmVsX2RhdGUnLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRcdG9yZGVyOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZGVsZXRlX21vZGFsX2xhYmVsX29yZGVyJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0XHRjdXN0b21lcjoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2RlbGV0ZV9tb2RhbF9sYWJlbF9jdXN0b21lcicsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSxcblx0XHRcdH0pLFxuXHRcdFx0cHJvcHM6IHtcblx0XHRcdFx0d2l0aGRyYXdhbDoge1xuXHRcdFx0XHRcdHR5cGU6IE9iamVjdCxcblx0XHRcdFx0fVxuXHRcdFx0fSxcblx0XHRcdHdhdGNoOiB7XG5cdFx0XHRcdHdpdGhkcmF3YWwobmV3VmFsKSB7XG5cdFx0XHRcdFx0aWYgKG5ld1ZhbCAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRcdFx0XHQkKCcuZGVsZXRlLW1vZGFsLm1vZGFsJykubW9kYWwoJ3Nob3cnKTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdH1cblx0XHRcdH0sXG5cdFx0XHRtZXRob2RzOiB7XG5cdFx0XHRcdGNvbmZpcm0oKSB7XG5cdFx0XHRcdFx0anNlLmxpYnMueGhyLnBvc3Qoe1xuXHRcdFx0XHRcdFx0dXJsOiAnLi9hZG1pbi5waHA/ZG89V2l0aGRyYXdhbHMvRGVsZXRlV2l0aGRyYXdhbCcsXG5cdFx0XHRcdFx0XHRkYXRhOiB7aWQ6IHRoaXMud2l0aGRyYXdhbC5pZH1cblx0XHRcdFx0XHR9KS5kb25lKHJlc3BvbnNlID0+IHtcblx0XHRcdFx0XHRcdHRoaXMuJGVtaXQoJ3JlbG9hZC1vdmVydmlldycpO1xuXHRcdFx0XHRcdH0pLmZhaWwoKHJlc3BvbnNlKSA9PiB7XG5cdFx0XHRcdFx0XHRjb25zb2xlLmVycm9yKCdDb3VsZCBub3QgbG9hZCB3aXRoZHJhd2FsIGRldGFpbHMuJywgcmVzcG9uc2UpO1xuXHRcdFx0XHRcdFx0anNlLmxpYnMuaW5mb19tZXNzYWdlcy5hZGRFcnJvcihqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZXJyb3JfY291bGRfbm90X2RlbGV0ZV93aXRoZHJhd2FsJywgJ3dpdGhkcmF3YWxzJykpO1xuXHRcdFx0XHRcdH0pO1xuXHRcdFx0XHRcdCQoJy5kZWxldGUtbW9kYWwubW9kYWwnKS5tb2RhbCgnaGlkZScpO1xuXHRcdFx0XHR9LFxuXHRcdFx0fSxcblx0XHRcdGluaXQ6IGRvbmUgPT4gZG9uZSgpXG5cdFx0fVxuXHR9KTsiXX0=
